/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;

public abstract class BlockFireBowl
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE = BlockFireBowl.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CULL_SHAPE = Shapes.m_83124_((VoxelShape)BlockFireBowl.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockFireBowl.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), BlockFireBowl.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), BlockFireBowl.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), BlockFireBowl.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0)});
    public static final BooleanProperty FIRE = BNBlockProperties.FIRE;

    protected BlockFireBowl(Block source) {
        super(FabricBlockSettings.copyOf((BlockBehaviour)source).m_60955_().m_60953_(BlockFireBowl::getLuminance));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FIRE, (Comparable)Boolean.valueOf(false)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected static int getLuminance(BlockState state) {
        return state.m_61145_((Property)FIRE).orElse(false) != false ? 15 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FIRE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return CULL_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() == Direction.UP) {
            if (player.m_21205_().m_41720_() == Items.f_42409_ && !((Boolean)state.m_61143_((Property)FIRE)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)FIRE, (Comparable)Boolean.valueOf(true)));
                if (!player.m_7500_() && !world.f_46443_) {
                    player.m_21205_().m_220157_(1, world.f_46441_, (ServerPlayer)player);
                }
                world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
                return InteractionResult.SUCCESS;
            }
            if (player.m_21205_().m_41619_() && ((Boolean)state.m_61143_((Property)FIRE)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)FIRE, (Comparable)Boolean.valueOf(false)));
                world.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_5825_() && entity instanceof LivingEntity && ((Boolean)level.m_8055_(pos).m_61143_((Property)FIRE)).booleanValue()) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)FIRE)).booleanValue()) {
            if (random.m_188503_(24) == 0) {
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
            if (random.m_188503_(4) == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static BlockFireBowl from(Block source) {
        return (BlockFireBowl)BehaviourHelper.from((Block)source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BlockFireBowl
    implements BehaviourMetal {
        public Metal(Block source) {
            super(source);
        }
    }

    public static class Stone
    extends BlockFireBowl
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }

    public static class Wood
    extends BlockFireBowl
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }
    }
}

